#!/bin/bash
# Reveal Sound Spire (AU/VST) Uninstaller Script.
#
# Copyright (C) 2014-2014 Reveal Sound LTD

echo ""
echo "Reveal Sound Spire uninstaller script."
echo ""


test -x /usr/bin/sudo  || (echo "warning: Cannot find /usr/bin/sudo or it's not an executable"; exit 1)
test -x /bin/rm       || (echo "warning: Cannot find /bin/rm or it's not an executable"; exit 1)

echo "This script will remove all Reveal Sound Spire packages from all volumes. Do you want to proceed (yes/no, default: no)?"
while true; do
    read answer
    answer=${answer:-no}
    case "${answer}" in
        "yes" ) break;;
        "no" ) echo "Uninstall process has been cancelled by user" && exit 1 ;;
        * ) echo "Please answer 'yes' or 'no'.";;
    esac
done

NEWLINE=$'\n'

spire_packages="com.revealsound.spire.1.1.au.pkg${NEWLINE}com.revealsound.spire.1.1.vst.pkg${NEWLINE}com.revealsound.spire.1.1.aax.pkg${NEWLINE}com.revealsound.spire.1.1.vst3.pkg"
spire_dirs="/Library/Audio/Sounds/Banks/RevealSound/"


SAVEIFS=$IFS
IFS=$(echo -en "\n\b")

for v in `ls /Volumes`; do 
    vol_path="/Volumes/${v}/"
    declare -a files
    declare -a dirs
    declare -a pkgs

    for d in ${spire_dirs}; do
        test -d ${d} && dirs+=("${d}${NEWLINE}")
    done

    for pkg in ${spire_packages}; do
        if [ `pkgutil --pkgs --volume ${vol_path} | grep -c ${pkg}` -ne 1 ]; then
            continue
        fi
        pkgs+=("${pkg}") 
        pkg_volume=`pkgutil --pkg-info ${pkg} --volume "${vol_path}" | grep volume | sed 's/\volume: //g'`
        pkg_volume_location=`pkgutil --pkg-info ${pkg} --volume "${vol_path}" | grep location | sed 's/\location: //g'`
        pkg_location="${pkg_volume}${pkg_volume_location}"
        test -d "${pkg_location}" || continue
        pushd "${pkg_location}" > /dev/null
        if [ $? -eq 0 ]; then 
            dirs+=`pkgutil --only-dirs --files ${pkg} --volume ${vol_path}`
            /usr/bin/sudo -p "Please enter %u's password:" /bin/rm -rf ${dirs[@]} 
            rc=$?
            if test "$rc" -ne 0; then
                IFS=${SAVEIFS}
                echo "Error occur during deleting files" && exit 1
            fi
        fi
        popd > /dev/null
        /usr/bin/sudo -p "Please enter %u's password (removing $pkgs) from ${pkg_volume}:" pkgutil --forget ${pkg} --volume ${vol_path}
    done
done

if [ -z "${pkgs}" ]; then 
  echo ""
  echo "No Reveal Sound Spire plugin has been found on your Mac."
  echo ""
else 
  echo ""
  echo "Reveal Sound Spire plugin has been successfully removed from your Mac."
  echo ""
fi 

IFS=${SAVEIFS}
exit 0

